<?php
/**
 * Tabs settings
 *
 *
 * @link       https://wp-guppy.com
 * @since      1.0.0
 *
 * @package    wp-guppy
 * @subpackage wp-guppy/admin/templates
 */
global  $wpguppy_settings;
$default_active_tab         = !empty($wpguppy_settings['default_active_tab'])   ? $wpguppy_settings['default_active_tab'] : '';
$profanity_words            = !empty($wpguppy_settings['profanity_words'])      ? $wpguppy_settings['profanity_words'] : '';
$enabled_tabs               = !empty($wpguppy_settings['enabled_tabs'])         ? $wpguppy_settings['enabled_tabs'] : array();
$group_chat                 = !empty($wpguppy_settings['group_chat'])           ? $wpguppy_settings['group_chat'] : '';
$floating_window            = !empty($wpguppy_settings['floating_window'])      ? $wpguppy_settings['floating_window'] : 'enable';
$whatsapp_support           = !empty($wpguppy_settings['whatsapp_support'])     ? $wpguppy_settings['whatsapp_support'] : 'disable';
$guest_chat                 = !empty($wpguppy_settings['guest_chat'])           ? $wpguppy_settings['guest_chat'] : 'enable';
$floating_messenger         = !empty($wpguppy_settings['floating_messenger'])   ? $wpguppy_settings['floating_messenger'] : 'enable';
$messanger_page_id          = !empty($wpguppy_settings['messanger_page_id'])    ? $wpguppy_settings['messanger_page_id'] : '0';
$dock_layout_image          = !empty($wpguppy_settings['dock_layout_image'])    ? $wpguppy_settings['dock_layout_image'] : '';
$bottom_position            = !empty($wpguppy_settings['bottom_position'])      ? $wpguppy_settings['bottom_position'] : '0';
$right_position             = !empty($wpguppy_settings['right_position'])       ? $wpguppy_settings['right_position'] : '0';
$whatsapp_bg_image          = !empty($wpguppy_settings['whatsapp_bg_image'])    ? $wpguppy_settings['whatsapp_bg_image'] : '';
$delete_message             = !empty($wpguppy_settings['delete_message'])       ? $wpguppy_settings['delete_message'] : 'enable';
$clear_chat                 = !empty($wpguppy_settings['clear_chat'])           ? $wpguppy_settings['clear_chat'] : 'enable';
$report_user                = !empty($wpguppy_settings['report_user'])          ? $wpguppy_settings['report_user'] : 'enable';
$time_format                = !empty($wpguppy_settings['time_format'])          ? $wpguppy_settings['time_format'] : '12hrs';
$hide_acc_settings          = !empty($wpguppy_settings['hide_acc_settings'])    ? $wpguppy_settings['hide_acc_settings'] : 'no';
$hide_online_user_list      = !empty($wpguppy_settings['hide_online_user_list'])    ? $wpguppy_settings['hide_online_user_list'] : 'no';
$hide_online_user_list      = !empty($wpguppy_settings['hide_online_user_list'])    ? $wpguppy_settings['hide_online_user_list'] : 'no';
$display_name_as            = !empty($wpguppy_settings['display_name_as'])          ? $wpguppy_settings['display_name_as'] : 'firstname_lastletter';
$include_on_page            = !empty($wpguppy_settings['include_on_page'])          ? $wpguppy_settings['include_on_page'] : array();
$exclude_on_page            = !empty($wpguppy_settings['exclude_on_page'])          ? $wpguppy_settings['exclude_on_page'] : array();
$tab_sort_icon              = WPGuppy_GlobalSettings::get_plugin_url().'admin/images/sortv.svg';
$tab_sequence               = !empty($wpguppy_settings['tab_sequence']) ? $wpguppy_settings['tab_sequence'] : array( 'contacts', 'friends', 'blocked','private_chats', 'groups', 'posts', 'customer_support' );
$right_position             = intval( $right_position ) > 150 ? 150 : $right_position; // max value only 200 px
$bottom_position            = intval( $bottom_position ) > 150 ? 150 : $bottom_position; // max value only 200 px

$tab_options = array(
    'contacts'          => esc_html('Contacts list','wp-guppy'),
    'friends'           => esc_html('Friends list','wp-guppy'), 
    'blocked'           => esc_html('Blocked list','wp-guppy'),
    'private_chats'     => esc_html('Private chats','wp-guppy'),
    'groups'            => esc_html('Group chats','wp-guppy'),
    'posts'             => esc_html('Post chats','wp-guppy'),
    'customer_support'  => esc_html('Customer support chat','wp-guppy'),
);
$toggle_options = array( 'enable' => esc_html('Enabled','wp-guppy'), 'disable' => esc_html('Disabled','wp-guppy') );
if(!empty($group_chat) && $group_chat == 'enable'){
    array_push($enabled_tabs, 'groups');
}
?>

<div class="at-chatroles">
    <div class="at-chatroles_item">
        <div class="at-chatrole">
            <div class="at-chatrole_title">
                <h6><?php esc_html_e('Tabs settings','wp-guppy');?></h6>
            </div>
            <div class="at-chatrole_head">
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Default active tab','wp-guppy');?></h6>
                    <div class="at-select">
                        <select name="wpguppy_settings[default_active_tab]">
                            <?php 
                                foreach($tab_options as $key => $option){ ?>
                                    <option <?php echo $key == $default_active_tab ? 'selected' : '' ?> value="<?php echo $key ?>" ><?php echo $option;?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Enable tabs','wp-guppy');?></h6>
                </div>
                <ul class="at-roletabs_list" id="gp_guppy_tabs">
                    <?php foreach($tab_sequence as $tab){ ?>
                        <li>
                            <div class="at-checkbox">
                                <input type="hidden" name="wpguppy_settings[tab_sequence][]" value="<?php echo $tab ?>">
                                <input id="<?php echo esc_attr_e($tab)?>" <?php echo in_array($tab, $enabled_tabs) ? esc_attr('checked') : '' ;?> type="checkbox" name="wpguppy_settings[enabled_tabs][]" value="<?php echo $tab ?>">
                                <label for="<?php echo esc_attr_e($tab)?>" class="at-sorting">
                                    <em class="dashicons dashicons-yes">
                                        <img src="<?php echo esc_attr($tab_sort_icon); ?>" alt="<?php echo esc_html('sort list icon', 'wp-guppy'); ?>">
                                    </em>
                                    <span><?php echo $tab_options[$tab] ?></span>
                                </label>
                            </div>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="at-chatroles_item">
        <div class="at-chatrole">
            <div class="at-chatrole_title">
                <h6><?php esc_html_e('Floating widget settings','wp-guppy');?></h6>
            </div>
            <div class="at-chatrole_head">
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Dock layout Image','wp-guppy');?></h6>
                    <input name="wpguppy_settings[dock_layout_image]" placeholder="<?php esc_attr_e('Enter dock layout image URL','wp-guppy');?>" type="text"  value="<?php echo esc_url($dock_layout_image);?>"/>
                    <p class="description"><?php esc_html_e('You can upload the dock layout image into WordPress media and copy that URL and add it here for the dock image.','wp-guppy');?>
                </div>
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Whatsapp chat background image','wp-guppy');?></h6>
                    <input name="wpguppy_settings[whatsapp_bg_image]" placeholder="<?php esc_attr_e('Image URL','wp-guppy');?>" type="text" value="<?php echo esc_url($whatsapp_bg_image);?>"/>
                    <p class="description"><?php esc_html_e('You can upload a background image into WordPress media and copy that URL and add it here for chat backgroud image.','wp-guppy');?>
                </div>
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Adjust dock layout image position','wp-guppy');?></h6>
                    <h6><?php esc_html_e('Add bottm space','wp-guppy');?></h6>
                    <input name="wpguppy_settings[bottom_position]" placeholder="<?php esc_attr_e('Enter bottom','wp-guppy');?>" type="text"  value="<?php echo intval($bottom_position);?>"/>
                    <p><?php esc_html_e('Please be sure space value should not be more than 150','wp-guppy'); ?></p>
                    <h6><?php esc_html_e('Add right space','wp-guppy');?></h6>
                    <input name="wpguppy_settings[right_position]" placeholder="<?php esc_attr_e('Enter right','wp-guppy');?>" type="text"  value="<?php echo intval($right_position);?>"/>
                    <p class="description"><?php esc_html_e('Please be sure space value should not be more than 150','wp-guppy');?></p>
                </div>
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Include on page','wp-guppy');?></h6>
                    <?php $page_ids=get_all_page_ids(); ?>
                    <select class="at-multiselect2" name="wpguppy_settings[include_on_page][]" multiple="multiple">
                        <?php foreach($page_ids as $page) { 
                            $selected = in_array($page,$include_on_page) ? 'selected' : '';
                            ?>
                                <option <?php echo esc_attr($selected) ?> value="<?php echo intval($page) ?>"><?php echo esc_html(get_the_title($page)) ?></option>
                        <?php 
                            } 
                        ?>
                    </select>
                </div>
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Exlude on page','wp-guppy');?></h6>
                    <select class="at-multiselect2" name="wpguppy_settings[exclude_on_page][]" multiple="multiple">
                        <?php 
                        foreach($page_ids as $page) { 
                            if( !in_array($page,$include_on_page) ) { 
                                $selected = in_array($page,$exclude_on_page) ? 'selected' : ''; ?>
                                <option <?php echo esc_attr($selected) ?> value="<?php echo intval($page) ?>"><?php echo esc_html(get_the_title($page)) ?></option>
                        <?php }
                        } 
                        ?>
                    </select>
                </div>
                <div class="role_wrapper">
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-grid-view"></i>
                            <span><?php esc_html_e('Enable widget window','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[floating_window]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($floating_window) && $floating_window == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[floating_window]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-image-rotate-right"></i>
                            <span><?php esc_html_e('Enable floating messenger','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[floating_messenger]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($floating_messenger) && $floating_messenger == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[floating_messenger]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-whatsapp"></i>
                            <span><?php esc_html_e('Enable whatsapp support','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[whatsapp_support]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($whatsapp_support) && $whatsapp_support == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[whatsapp_support]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-businessperson"></i>
                            <span><?php esc_html_e('Allow guest user chat','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[guest_chat]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($guest_chat) && $guest_chat == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[guest_chat]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="at-chatroles_item">
        <div class="at-chatrole">
            <div class="at-chatrole_title">
                <h6><?php esc_html_e('Other settings','wp-guppy');?></h6>
            </div>
            <div class="at-chatrole_head">
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Select messenger page','wp-guppy');?></h6>
                    <div class="at-select">
                    <?php
                        $args = array(
                            'depth'                 => 0,
                            'child_of'              => 0,
                            'selected'              => $messanger_page_id ,
                            'echo'                  => 1,
                            'name'                  => 'wpguppy_settings[messanger_page_id]',
                            'id'                    => null, // string
                            'class'                 => null, // string
                            'show_option_none'      => null, // string
                            'show_option_no_change' => null, // string
                            'option_none_value'     => null, // string
                        );
                        wp_dropdown_pages( $args ); 
                        ?>
                        </div>
                </div>
                
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Display name as','wp-guppy');?></h6>
                    <?php $display_name_options = array(
                        'first_name'            => esc_html__('First name','wp-guppy'),
                        'last_name'             => esc_html__('Last name','wp-guppy'),
                        'full_name'             => esc_html__('Full name','wp-guppy'),
                        'lastname_firstname'    => esc_html__('Last name first name','wp-guppy'),
                        'firstname_lastletter'  => esc_html__('First Name first letter of last name','wp-guppy'),
                    ); 
                    ?>
                     <div class="at-select">
                        <select name="wpguppy_settings[display_name_as]">
                            <?php 
                                foreach($display_name_options as $key => $option){ ?>
                                    <option <?php echo $key == $display_name_as ? 'selected' : '' ?> value="<?php echo $key ?>" ><?php echo $option;?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="at-roletabs_search at-roletabs_searchvtwo">
                    <h6><?php esc_html_e('Add profanity words to filter','wp-guppy');?></h6>
                    <textarea name="wpguppy_settings[profanity_words]" placeholder="<?php esc_attr_e('Add multiple profanity words','wp-guppy');?>" rows="8" cols="60"><?php echo do_shortcode(stripslashes($profanity_words));?></textarea>
                    <p class="description"><?php esc_html_e('Please separate multiple words with a comma (,) without any space','wp-guppy');?></p>
                </div>
    
                <div class="role_wrapper">

                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-trash"></i>
                            <span><?php esc_html_e('Delete message option','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[delete_message]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($delete_message) && $delete_message == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[delete_message]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
        
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-format-chat"></i>
                            <span><?php esc_html_e('Clear chat option','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[clear_chat]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($clear_chat) && $clear_chat == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[clear_chat]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
        
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-database"></i>
                            <span><?php esc_html_e('Report user option','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[report_user]" value="disable" />
                                <input class="at-chat_option" <?php if( !empty($report_user) && $report_user == 'enable') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[report_user]" value="enable">
                                <i></i>
                            </label>
                        </div>
                    </div>
        
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-clock"></i>
                            <span><?php esc_html_e('Time format','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('12-hour clock','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[time_format]" value="24hrs" />
                                <input class="at-chat_option" <?php if( !empty($time_format) && $time_format == '12hrs') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[time_format]" value="12hrs">
                                <i></i>
                            </label>
                        </div>
                    </div>
        
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-admin-settings"></i>
                            <span><?php esc_html_e('Hide account settings','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[hide_acc_settings]" value="no" />
                                <input class="at-chat_option" <?php if( !empty($hide_acc_settings) && $hide_acc_settings == 'yes') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[hide_acc_settings]" value="yes">
                                <i></i>
                            </label>
                        </div>
                    </div>
        
                    <div class="at-roleoption">
                        <div class="at-roleoption_info">
                            <i class="dashicons dashicons-businessperson"></i>
                            <span><?php esc_html_e('Hide online users list','wp-guppy');?></span>
                        </div>
                        <div class="at-roleoption_radio at-switchbtn">
                            <label>
                                <span><?php echo esc_html('Enabled','wp-guppy') ;?></span>
                                <input type="hidden" name="wpguppy_settings[hide_online_user_list]" value="no" />
                                <input class="at-chat_option" <?php if( !empty($hide_online_user_list) && $hide_online_user_list == 'yes') {?>checked="checked"<?php } ?> type="checkbox" name="wpguppy_settings[hide_online_user_list]" value="yes">
                                <i></i>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<!-- End -->